#include "stdafx.h"
#include "RFApp.h"
#include "RFDoc.h"

#include "Control.h"

//
// CControl
//
IMPLEMENT_DYNCREATE(CControl, CFormView)

//
// Constructor
//
CControl::CControl()
	: CFormView(CControl::IDD)
{
	// Collect pointers to dlg items?
}

//
// Deconstructor
//
CControl::~CControl()
{
}

//
// Sync settings with dlg entry 
//
void CControl::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	
	DDX_Text(pDX, IDC_CENTER_FREQ, settings.center);
	DDV_MinMaxDouble(pDX, settings.center, 1.1, 6.0e3);

	DDX_Text(pDX, IDC_BANDWIDTH, settings.bandwidth);
	DDV_MinMaxDouble(pDX, settings.bandwidth, 0.1, 27.0);

	DDX_Text(pDX, IDC_GAIN, settings.gain);
	DDV_MinMaxInt(pDX, settings.gain, 0, 3);

	DDX_Text(pDX, IDC_ATTEN, settings.atten);
	DDV_MinMaxInt(pDX, settings.atten, 0, 30);

	DDX_Text(pDX, IDC_TITLE, settings.captureTitle);
	DDX_Text(pDX, IDC_PATH_EDIT, settings.path);
}

BEGIN_MESSAGE_MAP(CControl, CFormView)
	ON_BN_CLICKED(IDC_UPDATE, &CControl::OnClickedUpdate)
	ON_BN_CLICKED(IDC_RECORD, &CControl::OnClickedRecord)
	ON_BN_CLICKED(IDC_SET_PATH, &CControl::OnClickedSetPath)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_REFRESH_SLIDER, &CControl::OnRefreshSliderChanged)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_RES_SLIDER, &CControl::OnResolutionSliderChanged)
	ON_BN_CLICKED(IDC_CAP_TRIGGERS, &CControl::OnBnClickedCapTriggers)
	ON_BN_CLICKED(IDC_EXT_TIMEBASE, &CControl::OnBnClickedExtTimebase)
END_MESSAGE_MAP()

//
// CControl diagnostics
//
#ifdef _DEBUG
void CControl::AssertValid() const
{
	CFormView::AssertValid();
}

#ifndef _WIN32_WCE
void CControl::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif
#endif //_DEBUG

void CControl::OnDraw(CDC* pDC)
{
	//CButton *recordButton;

	//recordButton = (CButton*)GetDlgItem(IDC_RECORD);
	//if( ((CRFDoc*)GetDocument())->IsRecording() ) {
	//	recordButton->SetWindowTextA("Stop Recording");
	//} else {
	//	recordButton->SetWindowTextA("Start Recording");
	//}
}

//
// OnInitialUpdate
// Prevent Flickering of activeX controls
// Initialize any controls
//
void CControl::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();

	// Prevent flickering
	ModifyStyle(NULL ,WS_CLIPCHILDREN ,0);

	// Collect permanent control variables
	refreshCntl = (CSliderCtrl*)GetDlgItem(IDC_REFRESH_SLIDER);
	refreshCntl->SetRange(-25, -5);
	refreshCntl->SetPos(-viewSettings.refreshRate);

	resolutionSlider = (CSliderCtrl*)GetDlgItem(IDC_RES_SLIDER);
	resolutionSlider->SetRange(10, 14);
	for(int i = 10; i < 14; i++) {
		resolutionSlider->SetTic(i);
	}

	// Temporary control variables
	CEdit *titleEdit = (CEdit*)GetDlgItem(IDC_TITLE);
	CEdit *pathEdit = (CEdit*)GetDlgItem(IDC_PATH_EDIT);
	CComboBox *decimationBox = (CComboBox*)GetDlgItem(IDC_DECIMATION);
	CComboBox *gainBox = (CComboBox*)GetDlgItem(IDC_GAIN);
	CComboBox *attenBox = (CComboBox*)GetDlgItem(IDC_ATTEN);
	CComboBox *extBox = (CComboBox*)GetDlgItem(IDC_EXT_TYPE);

	titleEdit->SetWindowTextA("Enter Capture Title");
	pathEdit->SetWindowTextA(settings.path);

	decimationBox->AddString("None");
	decimationBox->AddString("2");
	decimationBox->AddString("4");
	decimationBox->AddString("8");
	decimationBox->AddString("16");
	decimationBox->AddString("32");
	decimationBox->AddString("64");
	decimationBox->AddString("128");
	decimationBox->SetCurSel(0);

	gainBox->AddString("0");
	gainBox->AddString("1");
	gainBox->AddString("2");
	gainBox->AddString("3");
	gainBox->SetCurSel(2);

	attenBox->AddString("0");
	attenBox->AddString("10");
	attenBox->AddString("20");
	attenBox->AddString("30");
	attenBox->SetCurSel(1);

	extBox->AddString("AC Coupled");
	extBox->AddString("DC Coupled");
	extBox->SetCurSel(0);
}

//
// Send the title and settings to the document
//
void CControl::OnClickedUpdate()
{
	if(!UpdateData()) {
		return;
	}

	CComboBox* extTypeBox = (CComboBox*)GetDlgItem(IDC_EXT_TYPE);
	int extSel = extTypeBox->GetCurSel();
	
	if(extSel == 0) settings.extType = bbSettings_t::AC_COUPLED;
	if(extSel == 1) settings.extType = bbSettings_t::DC_COUPLED;

	CComboBox* decimate = (CComboBox*)GetDlgItem(IDC_DECIMATION);
	settings.decimation = decimate->GetCurSel();

	settings.capture_len = BASE_CAPTURE / (0x1 << settings.decimation);

	((CRFDoc*)GetDocument())->Reconfigure(settings);
}

//
// Start/Stop Record
//
void CControl::OnClickedRecord()
{
	if(!UpdateData()) {
		return;
	}

	CRFDoc* doc = ((CRFDoc*)GetDocument());

	if(!(settings == *doc->GetSettings())) {
		AfxMessageBox("Settings are not updated. "
			"Click update before recording");
		return;
	}

	doc->StartStopRecord();
}

//
// The user sets a folder path?
//
void CControl::OnClickedSetPath()
{
	CString newPath;
	// Folder Browser code.
	BROWSEINFO bi;
	ZeroMemory(&bi, sizeof(BROWSEINFO));

	bi.hwndOwner = m_hWnd;
	bi.ulFlags   = BIF_RETURNONLYFSDIRS;

	LPITEMIDLIST pidl = SHBrowseForFolder(&bi);

	BOOL bRet = FALSE;

	char szFolder[MAX_PATH*2];
	szFolder[0] = '\0';

	if(pidl) {
		if(SHGetPathFromIDList(pidl, szFolder)) {
			bRet = TRUE;
		}
		IMalloc *pMalloc = NULL; 
		if(SUCCEEDED(SHGetMalloc(&pMalloc)) && pMalloc) {  
			pMalloc->Free(pidl);  
			pMalloc->Release(); 
		}
	}

	if(!bRet) return;

	newPath = szFolder;
	newPath.Append("\\");

	if(DirectoryExists(newPath)) {
		CEdit *pathEdit = (CEdit*)GetDlgItem(IDC_PATH_EDIT);
		pathEdit->SetWindowTextA(newPath);
		settings.path = newPath;
	} else {
		AfxMessageBox("Directory Entered is not a valid directory");
	}
}

// 
// Changed the refresh rate, notify the client immediately
//
void CControl::OnRefreshSliderChanged(NMHDR *pNMHDR, LRESULT *pResult)
{
	refreshCntl = (CSliderCtrl*)GetDlgItem(IDC_REFRESH_SLIDER);
	viewSettings.refreshRate = -refreshCntl->GetPos();	

	((CRFDoc*)GetDocument())->UpdateViewSettings(viewSettings);

	*pResult = 0;
}

//
// Changed the resolution
//
void CControl::OnResolutionSliderChanged(NMHDR *pNMHDR, LRESULT *pResult)
{
	resolutionSlider = (CSliderCtrl*)GetDlgItem(IDC_RES_SLIDER);
	viewSettings.resolution = resolutionSlider->GetPos();

	((CRFDoc*)GetDocument())->UpdateViewSettings(viewSettings);

	*pResult = 0;
}

// 
// Changed the captureTrigger checkbox
//
void CControl::OnBnClickedCapTriggers()
{
	CButton* trigCheck = (CButton*)GetDlgItem(IDC_CAP_TRIGGERS);

	settings.captureTrigger = trigCheck->GetCheck() == BST_CHECKED ? true : false;
}

//
// Changed Ext Timebase to on
//
void CControl::OnBnClickedExtTimebase()
{
	CButton *extOn = (CButton*)GetDlgItem(IDC_EXT_TIMEBASE);

	settings.extTimebase = extOn->GetCheck() == BST_CHECKED ? true : false;

}
